<?php

/**
 * This code was generated by
 * \ / _    _  _|   _  _
 * | (_)\/(_)(_|\/| |(/_  v1.0.0
 * /       /
 */

namespace Twilio\Rest\Chat\V2\Service;

use Twilio\Deserialize;
use Twilio\Exceptions\TwilioException;
use Twilio\InstanceResource;
use Twilio\Values;
use Twilio\Version;

/**
 * @property string sid
 * @property string accountSid
 * @property string serviceSid
 * @property string friendlyName
 * @property string type
 * @property string permissions
 * @property \DateTime dateCreated
 * @property \DateTime dateUpdated
 * @property string url
 */
class RoleInstance extends InstanceResource {
	/**
	 * Initialize the RoleInstance
	 *
	 * @param \Twilio\Version $version Version that contains the resource
	 * @param mixed[] $payload The response payload
	 * @param string $serviceSid The unique id of the Service this role belongs to.
	 * @param string $sid The sid
	 *
	 * @return \Twilio\Rest\Chat\V2\Service\RoleInstance
	 */
	public function __construct( Version $version, array $payload, $serviceSid, $sid = null ) {
		parent::__construct( $version );

		// Marshaled Properties
		$this->properties = array(
			'sid'          => Values::array_get( $payload, 'sid' ),
			'accountSid'   => Values::array_get( $payload, 'account_sid' ),
			'serviceSid'   => Values::array_get( $payload, 'service_sid' ),
			'friendlyName' => Values::array_get( $payload, 'friendly_name' ),
			'type'         => Values::array_get( $payload, 'type' ),
			'permissions'  => Values::array_get( $payload, 'permissions' ),
			'dateCreated'  => Deserialize::dateTime( Values::array_get( $payload, 'date_created' ) ),
			'dateUpdated'  => Deserialize::dateTime( Values::array_get( $payload, 'date_updated' ) ),
			'url'          => Values::array_get( $payload, 'url' ),
		);

		$this->solution = array( 'serviceSid' => $serviceSid, 'sid' => $sid ?: $this->properties['sid'], );
	}

	/**
	 * Fetch a RoleInstance
	 *
	 * @return RoleInstance Fetched RoleInstance
	 * @throws TwilioException When an HTTP error occurs.
	 */
	public function fetch() {
		return $this->proxy()->fetch();
	}

	/**
	 * Generate an instance context for the instance, the context is capable of
	 * performing various actions.  All instance actions are proxied to the context
	 *
	 * @return \Twilio\Rest\Chat\V2\Service\RoleContext Context for this
	 *                                                  RoleInstance
	 */
	protected function proxy() {
		if ( ! $this->context ) {
			$this->context = new RoleContext(
				$this->version,
				$this->solution['serviceSid'],
				$this->solution['sid']
			);
		}

		return $this->context;
	}

	/**
	 * Deletes the RoleInstance
	 *
	 * @return boolean True if delete succeeds, false otherwise
	 * @throws TwilioException When an HTTP error occurs.
	 */
	public function delete() {
		return $this->proxy()->delete();
	}

	/**
	 * Update the RoleInstance
	 *
	 * @param string $permission A permission this role should have.
	 *
	 * @return RoleInstance Updated RoleInstance
	 * @throws TwilioException When an HTTP error occurs.
	 */
	public function update( $permission ) {
		return $this->proxy()->update( $permission );
	}

	/**
	 * Magic getter to access properties
	 *
	 * @param string $name Property to access
	 *
	 * @return mixed The requested property
	 * @throws TwilioException For unknown properties
	 */
	public function __get( $name ) {
		if ( array_key_exists( $name, $this->properties ) ) {
			return $this->properties[ $name ];
		}

		if ( property_exists( $this, '_' . $name ) ) {
			$method = 'get' . ucfirst( $name );

			return $this->$method();
		}

		throw new TwilioException( 'Unknown property: ' . $name );
	}

	/**
	 * Provide a friendly representation
	 *
	 * @return string Machine friendly representation
	 */
	public function __toString() {
		$context = array();
		foreach ( $this->solution as $key => $value ) {
			$context[] = "$key=$value";
		}

		return '[Twilio.Chat.V2.RoleInstance ' . implode( ' ', $context ) . ']';
	}
}